#pragma rtGlobals=1		// Use modern global access method.
#pragma version=3.1

// ********** Kaiser Low Pass *******

Function KaiserLowPassReset()
	KaiserLowPassSetupDesign()
	SetAxis/A/Z bottom			// in case user set a manual X axis range
	Execute "klp_compute(\"\")"
End

Function ButtonKaiserWindowLowPass(ctrlName) : ButtonControl
	String ctrlName

	DoWindow/F WMKaiserLowPassDesign
	if( V_Flag==0 )
		KaiserLowPassSetupDesign()
	endif
End

Function KaiserLowPassSetupDesign()

	SetApplyButtonTitle(0)

	NVAR fs= root:Packages:WM_IFDL:fs
	String dfSav= Set_IFDL_DataFolder()

	Variable sAttn=NumVarOrDefault("root:Packages:WM_IFDL:klp_satt",30)
	Variable pEnd=NumVarOrDefault("root:Packages:WM_IFDL:klp_pe",0.2)
	Variable sStrt=NumVarOrDefault("root:Packages:WM_IFDL:klp_ss",0.3)
	Variable eo=     NumVarOrDefault("root:Packages:WM_IFDL:klp_eo",2)

	sAttn=abs(sAttn)

	// Create the globals
	Variable/G klp_pe=pEnd
	Variable/G klp_ss=sStrt
	Variable/G klp_satt=sAttn
	Variable/G klp_eo=eo
	Variable/G klp_n=NumVarOrDefault("klp_n",NaN)

	// scale the saved normalized frequencies for the SetVariable controls
	Variable/G klp_pe_fs= pEnd * fs
	Variable/G klp_ss_fs= sStrt * fs
	
	SetDataFolder dfSav

	KaiserLowPassUpdate()
	
	CreateKaiserLowPassDesign()
	KaiserLowPassUpdate()			// set the control limits, too.
End

Function KaiserLowPassUpdate()
	String dfSav= Set_IFDL_DataFolder()
	NVAR fs= fs
	Variable pEndFs=NumVarOrDefault("klp_pe_fs",0.2*fs)
	Variable sStrtFs=NumVarOrDefault("klp_ss_fs",0.25*fs)
	Variable sAttn=NumVarOrDefault("klp_satt",40)
	Variable eo=     NumVarOrDefault("klp_eo",2)

	sAttn= abs(sAttn)

	// Save the normalized frequencies in case the user changes sampling frequency
	Variable/G klp_pe=pEndFs/fs
	Variable/G klp_ss=sStrtFs/fs

	// Passband and stop band response pair, in dB
	Make/O klp_responseX = {0,pEndFs,NaN,sStrtFs,fs*0.5}
	Make/O klp_response  = {0,0,NaN,-sAttn,-sAttn}
	// transition region waves, in dB
	Make/O     klp_transitionX = {klp_responseX[1],klp_responseX[3]}
	Make/O/N=2 klp_transitionPlus = 0
	SetScale d,0,0,"dB", klp_transitionPlus
	Make/O/N=2 klp_transitionMinus = -sAttn

	DoWindow WMKaiserLowPassDesign
	if( V_Flag == 1 ) // don't allow the end of the pass band to exceed the start of the stop band
		ControlInfo/W=WMKaiserLowPassDesign klp_PE
		Variable passBandEnd= V_Value
		ControlInfo/W=WMKaiserLowPassDesign klp_sStrt
		Variable stopBandStart= V_Value

		// back-compute from max n the minimum separation of stopBandStart and passBandEnd
		Variable minTransitionWidth = klpDeltaFreqForMaxTerms(sAttn,eo)
		Variable df=  NiceNumber(fs/200)

		// don't make max smaller than current value
		Variable endMax= max(passBandEnd,stopBandStart-minTransitionWidth)
		endMax= limit(endMax,0,fs/2)
		SetVariable klp_PE,limits={0,endMax,df},win=WMKaiserLowPassDesign

		// don't make min bigger than current value
		Variable startMin= min(stopBandStart,passBandEnd+minTransitionWidth)
		startMin= limit(startMin,0, fs/2)
		SetVariable klp_sStrt,limits={startMin,fs/2,df},win=WMKaiserLowPassDesign

		// show the computed number of terms before computing the filter.
		Variable/G klp_n= klpTerms(sAttn,pEndFs/fs,sStrtFs/fs,eo)
		ControlUpdate/A/W=WMKaiserLowPassDesign
	endif
	SetDataFolder dfSav
End

Function CreateKaiserLowPassDesign()

	if( DesignGraph("WMKaiserLowPassDesign","Kaiser Low Pass Design") )
		return 1	// already existed, don't reset the graph settings.
	endif

	NVAR fs= root:Packages:WM_IFDL:fs
	Variable df= NiceNumber(fs/200)	// 1,2,5 increment for SetVariable controls

	String dfSav= Set_IFDL_DataFolder()
	AppendToGraph/L=responseLeft  klp_transitionPlus,klp_transitionMinus vs klp_transitionX
	AppendToGraph/L=responseLeft klp_response vs klp_responseX
	SetDataFolder dfSav

	ModifyGraph mode(klp_transitionPlus)=7
	ModifyGraph lSize(klp_transitionPlus)=0,lSize(klp_transitionMinus)=0
	ModifyGraph rgb(klp_transitionPlus)=(56797,56797,56797)
	ModifyGraph hbFill(klp_transitionPlus)=2
	ModifyGraph toMode(klp_transitionPlus)=1
	ModifyGraph lblPos(responseLeft)=56
	ModifyGraph freePos(responseLeft)={0,bottom}
	ModifyGraph margin(left)=67
	ModifyGraph minor(bottom)=1
	SetAxis/A/N=1 responseLeft
	Label responseLeft "response (dB)"
	ControlBar 64
	SetVariable klp_PE,pos={11,3},size={211,17},proc=KaiserLP,title="End of Pass Band"
	SetVariable klp_PE,limits={0,fs/2,df},value= root:Packages:WM_IFDL:klp_pe_fs
	SetVariable klp_sStrt,pos={237,3},size={245,17},proc=KaiserLP,title="Start of Stop Band"
	SetVariable klp_sStrt,limits={0,fs/2,df},value= root:Packages:WM_IFDL:klp_ss_fs
	SetVariable klp_sAttn,pos={236,23},size={246,17},proc=KaiserLP,title="Min Stop Band Attenuation (dB)"
	SetVariable klp_sAttn,limits={21,100,5},value= root:Packages:WM_IFDL:klp_satt
	PopupMenu klp_evenOdd,pos={11,23},size={167,19},proc=klpEvenOddPopup,title="Number of Terms"
	PopupMenu klp_evenOdd,mode=2,popvalue="odd",value= #"\"even;odd\""
	ValDisplay klpTerms,pos={18,44},size={202,17},title="Computed Terms:",frame=0
	ValDisplay klpTerms,limits={0,0,0},barmisc={0,1000}, frame=(IsWindowsPlatform())
	ValDisplay klpTerms,value= #"root:Packages:WM_IFDL:klp_n"
	Button klpCompute,pos={271,43},size={109,19},proc=klp_compute,title="Compute Filter"

	Textbox/N=klpLegend/X=-0.73/Y=18.02 ""

	klpLegend()
	SetWindow WMKaiserLowPassDesign, hook=designHook
	return 0
End

Function klpLegend()
	DesignLegend("WMKaiserLowPassDesign","klp","klpLegend")
End

Function klpEvenOddPopup(ctrlName,popNum,popStr) : PopupMenuControl
	String ctrlName
	Variable popNum	// which item is currently selected (1-based)
	String popStr		// contents of current popup item as string

	NVAR eo= root:Packages:WM_IFDL:klp_eo
	eo= popNum
	KaiserLowPassUpdate()
End

Function KaiserLP(ctrlName,varNum,varStr,varName) : SetVariableControl
	String ctrlName
	Variable varNum
	String varStr
	String varName
	
	KaiserLowPassUpdate()
End

Function klpTerms(ar,fp,fr,eo)
	Variable ar	// reject band attenuation in dB
	Variable fp // end frequency of pass band in fraction of fs
	Variable fr // start frequency of reject band in fraction of fs
	Variable eo // even;odd item, 1 == even number of terms, 2 == odd number of terms

	Variable deltaf=fr-fp
	Variable n=ceil((ar-7.95)/(14.36*deltaf))+1
	if ((n-2*trunc(n/2)) != (eo-1))
		n += 1
	endif
	return n
End

// returns fp-fr as fraction of fs
// given eo and the min rejection attenuation in dB
Function klpDeltaFreqForMaxTerms(ar,eo)
	Variable ar	// reject band attenuation in dB
	Variable eo  // even;odd item, 1 == even number of terms, 2 == odd number of terms

	Variable maxterms=10000

	if ((maxterms-2*trunc(maxterms/2)) != (eo-1))
		maxterms += 1
	endif
	Variable deltaf= (ar-7.95)/(maxterms * 14.36)
	return deltaf
End

Proc klp_compute(ctrlName) : ButtonControl
	String ctrlName

	Silent 1;PauseUpdate	// Kaiser Low Pass...
	String dfSav= Set_IFDL_DataFolder()

	Variable sAttn= abs(NumVarOrDefault("klp_satt",30))
	Variable pEnd=NumVarOrDefault("klp_pe",0.2)
	Variable sStrt=NumVarOrDefault("klp_ss",0.3)
	Variable eo=     NumVarOrDefault("klp_eo",2)
	SetDataFolder dfSav
	Variable fs = root:Packages:WM_IFDL:fs
	
	if((sAttn<21)+(sAttn>100))
		abort "stopband attenuation should be in range 21 ... 100"
	endif
	if(pEnd >= sStrt)
		abort "passband frequency must be less than stopband"
	endif
	if( ChkFreq(pEnd,sStrt,0,0) )
		abort
	endif
	Variable n= klpTerms(sAttn,pEnd,sStrt,eo)
	if( n > 10001 )
		Abort "Too many filter terms. Widen the transition band or allow less stop band rejection"
	endif 
	Variable beta
	if(sAttn>50)
		beta=0.1102*(sAttn-8.7)
	else
		beta=0.5842*(sAttn-21)^0.4+0.07886*(sAttn-21)
	endif

	Set_IFDL_DataFolder()
	String/G proposedFilterName="kaiserLowPass"
	String/G designTypeName="Kaiser window; low pass"
	Variable/G designFlags=0x3
	Make/O bandInfo={1,0,pEnd*fs,0,sStrt*fs,0.5*fs}
	SetDataFolder dfSav

	Make/O/N=(n) coefs
	Variable nm1o2=(n-1)/2
	Variable fc=(sStrt+pEnd)/2
//	SetScale/P x,0,1,coefs
	coefs=2*fc*sinc(2*pi*fc*(p-nm1o2))
	Kaiser(coefs,beta)
	Variable sm=sum(coefs,-inf,inf)
	coefs /= sm		// normalize step response to unity

	StdCoefsTreatmentNoShowResults(0x1e,1)

	DoWindow/F WMKaiserLowPassDesign
	CheckDisplayed/W=WMKaiserLowPassDesign root:Packages:WM_IFDL:coefsDbMag
	if( V_Flag == 0 )
		Append/L=responseLeft root:Packages:WM_IFDL:coefsDbMag
		ModifyGraph rgb(coefsDbMag)=(0,0,65535)
	endif
	AppendPassDetails("detailsLeft",root:Packages:WM_IFDL:dbmagPassDetails)	// appends /L=detailsLeft
	AutoApplyFilter()
	klpLegend()
end
